
/************************************************************************
 *
 * \file: SignalHandler.h
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * <brief description>.
 * <detailed description>
 * \component: Android Auto - Demo application
 *
 * \author: J. Harder / ADITG/SW1 / jharder@de.adit-jv.com
 *
 * \copyright (c) 2015 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 * \see <related items>
 *
 * \history
 *
 ***********************************************************************/


#ifndef BDCLT_SIGNALHANDLER_H
#define BDCLT_SIGNALHANDLER_H

#include <list>
#include <sys/epoll.h>
#include <pthread_adit.h>
#include <utility/Singleton.h>
#include "IStoppable.h"

namespace adit { namespace bdcl {

class SignalHandler : public adit::utility::Singleton<SignalHandler>
{
public:
    SignalHandler();
    ~SignalHandler();

    void registerForSIGINT(IStoppable* inStoppable);
    void unregister(void* inPointer);

protected:
    static void handler(int inSignal);

    std::list<IStoppable*> stoppables;
private:
    bool mSignaled;


    static int32_t signalHandlerCb(void* context);
    int32_t epollRegisterSignalFd(int32_t epollFd);
    int32_t epollWaitSignalFd(int32_t epollFd, struct epoll_event* epollEvents);

    int32_t mEpollFd;

    static void* signalHandlerThread(void* context);

    /* ID of the EventThread */
    pthread_t mThreadId;

    int32_t mSignalFd;

    bool mRunning;
};

} } /* namespace adit { namespace bdcl */

#endif /* BDCLT_SIGNALHANDLER_H */
